classdef HW1Scenario
    %UNTITLED Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
        DeltaR;      % Rotation uncertainty for tracker
        DeltaP;      % Position uncertainty for tracker
        JoggleR;     % Amount of joggling
        JoggleP;
        pDt;         % Tool tip offset
        FBA;         % Frame A loc wrt FB
        FB;          % Nominal Frame B loc wrt tracking system
        FBX;         % Frame X loc wrt FB
        Nmarkers;    % Number of markers
        bMarkers;    % body markers wrt FB
        cMarkers;    % markers in CT images
        FBC;         % Registration of CT
        FCA;         % Anatomy A in CT
        FBM;         % Registration of MRI
        FMA;         % Anatomy A in MRI
        FMX;         % Anatomy X in MRI
    end
    
    methods
        function HW1 = HW1Scenario(DeltaR,DeltaP,JoggleR,JoggleP)
            HW1.DeltaR = DeltaR;
            HW1.DeltaP = DeltaP;
            HW1.JoggleR = JoggleR;
            HW1.JoggleP = JoggleP;            
            HW1.pDt = vct3(0,0,-150);
            HW1.FB  = Frame(RotMx.eye(),vct3(100,-50,-300));
            HW1.FBA = Frame(RotMx.eye(),vct3(100,150,-150));
            HW1.FBX = Frame(RotMx.eye(),vct3(50,-50,-100));
            HW1.FBM = Frame(RotMx.eye(),vct3(500,500,500));
            HW1.FBC = Frame(RotMx.eye(),vct3(100,200,300));
            HW1.bMarkers = vct3Array([50,50,0 ; -50,-100,-5; 150,50,-10;
                                      100, -100, 0]'); 
            HW1.Nmarkers = NumEl(HW1.bMarkers);
            HW1.cMarkers = HW1.FBC.Inverse()*HW1.bMarkers;
            HW1.FCA = HW1.FBC.Inverse()*HW1.FBA;
            HW1.FMA = HW1.FBM.Inverse()*HW1.FBA;
            HW1.FMX = HW1.FBM.Inverse()*HW1.FBX;
        end
        
        function [fma,fmx] = SegmentMRI(HW1)
            fma = HW1.FMA; fmx = HW1.FMX;
        end
        
        function [fca,cMarkers] = SegmentCT(HW1);
            fca = HW1.FCA;cMarkers = HW1.cMarkers;
        end
        
        function [FB,FD] = SampleAtMarker(HW1,i,xD,yD,zD)
            R = RotMx.xyzD(xD,yD,zD);
            FB = HW1.FB;
            FJ = Frame(RotMx.randD(HW1.JoggleR,HW1.JoggleR,HW1.JoggleR),vct3.rand(HW1.JoggleP));
            FB = FJ*FB;
            dF = Frame(RotMx.randD(HW1.DeltaR,HW1.DeltaR,HW1.DeltaR),vct3.rand(HW1.DeltaP)); % tracker error
            FB = FB*dF;
            b = FB*HW1.bMarkers(i);      % marker location with respect to tracker coordinates
            F = Frame(R,b-R*HW1.pDt);        % nominal tracker return value  
            dF = Frame(RotMx.randD(HW1.DeltaR,HW1.DeltaR,HW1.DeltaR),vct3.rand(HW1.DeltaP)); % tracker error
            FD = F*dF;
           
        end
        
    end
    
end

